% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixscale.R
\name{mixScale}
\alias{mixScale}
\title{Continuous Scale Mixture Approach for Normal Scale Mixture Model}
\usage{
mixScale(x, ini = NULL, maxiter = 100)
}
\arguments{
\item{x}{a vector of observations.}

\item{ini}{initial values for the parameters. Default is NULL, which obtains the initial values
using the \code{\link{mixnorm}} function. If specified, it can be a list with the form of
\code{list(pi, mu, sigma)}, where
\code{pi} is a vector of 2 mixing proportions,
\code{mu} is a vector of 2 component means, and
\code{sigma} is a vector of 2 component (common) standard deviations.}

\item{maxiter}{maximum number of iterations for the EM algorithm. Default is 100.}
}
\value{
A list containing the following elements:
\item{mu}{estimated component means.}
\item{pi}{estimated mixing proportions.}
\item{suppQ}{support of Q.}
\item{weightQ}{weight of Q corresponding to initial standard deviations.}
\item{loglik}{final log-likelihood.}
\item{run}{number of iterations after convergence.}
}
\description{
`mixScale' is used to estimate a two-component continuous normal scale mixture model, based on a backfitting method (Xiang et al., 2016):
\deqn{p(x;\boldsymbol{\theta},f) = \pi f_1(x-\mu_1) + (1-\pi)  f_2(x-\mu_2),}
where \eqn{\boldsymbol{\theta}=(\pi,\mu_1,\mu_2)}. Here, \eqn{f} is assumed to be a member of
\eqn{\mathcal{F} = \left\{ f(x) \big| \int\frac{1}{\sigma}\phi(x/\sigma)dQ(\sigma) \right\}},
where \eqn{\phi(x)} is the standard normal density and \eqn{Q} is an unspecified probability measure on positive real numbers.
}
\examples{
require(quadprog)

#-----------------------------------------------------------------------------------------#
# Example 1: simulation
#-----------------------------------------------------------------------------------------#
n = 10
mu = c(-2.5, 0)
sd = c(0.8, 0.6)
pi = c(0.3, 0.7)
set.seed(2023)
n1 = rbinom(n, 1, pi[1])
x = c(rnorm(sum(n1), mu[1], sd[1]), rnorm(n - sum(n1), mu[2], sd[2]))
ini = list(pi = pi, mu = mu, sigma = sd)
\donttest{out = mixScale(x, ini)}

#-----------------------------------------------------------------------------------------#
# Example 2: elbow data
#-----------------------------------------------------------------------------------------#
ini = mixnorm(elbow)
\donttest{res = mixScale(elbow, ini)}
}
\references{
Xiang, S., Yao, W., and Seo, B. (2016). Semiparametric mixture: Continuous scale mixture approach.
Computational Statistics & Data Analysis, 103, 413-425.
}
\seealso{
\code{\link{mixnorm}} for initial value calculation.
}
