% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiSpecimenSample.R
\name{MiSpecimenSample}
\alias{MiSpecimenSample}
\title{Select values from factor vector}
\usage{
MiSpecimenSample(x, group1, group2 = NULL)
}
\arguments{
\item{x}{factor vector}

\item{group1}{value of factor level to sample}

\item{group2}{additional value of factor level to sample}
}
\value{
factor vector with values for 1 or 2 levels only
}
\description{
This function takes factor vector with multiple levels and selects values for 1 or 2 levels only.
}
\details{
This function is ment for sampling specimens for binary classification when they belong to more
than two groups. The aim is to create factor vector with only two levels specifying specimens
in the columns of corresponding microarray expression matrix.
It should be used together with \code{\link{MiDataSample}} that samples columns of microarray
expression matrix in the same way.
}
\examples{
#get gene expression and specimen data
data("IMexpression");data("IMspecimen")
dim(IMexpression) # 100 columns (genes/transcripts) - 89 specimens
colnames(IMexpression)[1:10] # look at first 10 columns of matrix - specimens IDs
IMspecimen[1:10,] # specimens IDs and group factor - diagnoses in attendant vector
# note that specimens in matrix columns are in the same order as specimens in description data
# select specimens with only EBV and NORM diagnoses (and sample the description data as well)
SampleMatrix<-MiDataSample(IMexpression, IMspecimen$diagnosis, "ebv", "norm")
SampleSamples<-MiSpecimenSample(IMspecimen$diagnosis, "ebv", "norm")
dim(SampleMatrix)# only 68 specimens with EBV and NORM diagnoses left
colnames(SampleMatrix)[1:10]
SampleSamples[1:10] # corresponding diagnoses

}
\seealso{
\code{\link{MiDataSample}}
}
\author{
Elena N. Filatova
}
