% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space_time.R
\name{simulate_spacetime}
\alias{simulate_spacetime}
\title{space-time simulation based on implicit Euler discretization in time}
\usage{
simulate_spacetime(graph, t, kappa, rho, gamma, alpha, beta, sigma, u0, BC = 0)
}
\arguments{
\item{graph}{A \code{metric_graph} object.}

\item{t}{Vector of time points.}

\item{kappa}{Spatial range parameter.}

\item{rho}{Drift parameter.}

\item{gamma}{Temporal range parameter.}

\item{alpha}{Smoothness parameter (integer) for spatial operator.}

\item{beta}{Smoothness parameter (integer) for Q-Wiener process.}

\item{sigma}{Variance parameter.}

\item{u0}{Starting value.}

\item{BC}{Which boundary condition to use (0,1). Here, 0 is no adjustment on
the boundary and 1 results in making the boundary condition stationary.}
}
\value{
Precision matrix.
}
\description{
Simulation with starting value u0
}
