% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{compute_fitch}
\alias{compute_fitch}
\title{Compute Fitch Parsimony for Methylation Categories}
\usage{
compute_fitch(tree, meth, input_control = TRUE)
}
\arguments{
\item{tree}{A rooted binary tree in Newick format (character string) or as an \code{ape} phylo object.
Must have at least two tips.}

\item{meth}{A matrix of methylation categories at the tree tips, with rows corresponding to tips
(names matching tree tip labels) and columns corresponding to sites or structures.}

\item{input_control}{Logical; if \code{TRUE}, validates input consistency.}
}
\value{
A list containing:
\describe{
\item{\code{optStateSet}}{A list of sets of optimal states for the root at each site/structure.}
\item{\code{minChange_number}}{A numeric vector indicating the minimum number of changes for each site.}
}
}
\description{
This function applies Fitch parsimony to determine the minimum number of changes required for
methylation categories at tree tips.
}
\examples{
tree <- "((a:1,b:1):2,(c:2,d:2):1.5);"

meth <- matrix(c("u", "m", "p", "u", "p", "m", "m", "u"), 
               nrow=4, byrow=TRUE, dimnames=list(c("a", "b", "c", "d")))
               
compute_fitch(tree, meth)

}
