% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{categorize_siteMethSt}
\alias{categorize_siteMethSt}
\title{Categorize Methylation Frequencies Based on Thresholds}
\usage{
categorize_siteMethSt(data, u_threshold = 0.2, m_threshold = 0.8)
}
\arguments{
\item{data}{A list structured as \code{data[[tip]][[structure]]}, where \code{tip} corresponds to tree tips, and \code{structure}
corresponds to each genomic structure (e.g., island/non-island).}

\item{u_threshold}{A numeric value representing the upper bound for values to be classified as unmethylated (\code{0}). Default 0.2.}

\item{m_threshold}{A numeric value representing the lower bound for values to be classified as methylated (\code{1}). Default 0.8.}
}
\value{
A transformed version of \code{data} where each value is categorized as \code{0} (unmethylated), \code{0.5} (partially methylated),
or \code{1} (methylated).
}
\description{
This function categorizes the values in \code{data[[tip]][[structure]]} into three categories:
\itemize{
\item \code{0} for unmethylated sites, where values are smaller or equal to \code{u_threshold}.
\item \code{0.5} for partially methylated sites, where values are between \code{u_threshold} and \code{m_threshold}.
\item \code{1} for methylated sites, where values are larger or equal to \code{m_threshold}.
}
}
\details{
If any value in \code{data[[tip]][[structure]]} is outside these categories, it is transformed based on the given thresholds.
}
\examples{
data <- list(
list(c(0.1, 0.2, 0.02), c(0.05, 0.25, 0.15)), # tip 1
list(c(0.01, 0.7, 0.85), c(0.3, 0.1, 0.98)) # tip 2
)

transformed_data <- categorize_siteMethSt(data, u_threshold = 0.2, m_threshold = 0.8)
}
