% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_functions.R
\name{delete_words}
\alias{delete_words}
\alias{delete_words,MetaNLP,character-method}
\title{Delete list of words}
\usage{
delete_words(object, delete_list)

\S4method{delete_words}{MetaNLP,character}(object, delete_list)
}
\arguments{
\item{object}{A MetaNLP object, whose data frame is to be modified}

\item{delete_list}{A character vector containing the words to be deleted}
}
\value{
An object of class \code{MetaNLP}
}
\description{
There can be words that do not offer additional information
in the classification whether a paper should be included or excluded
from a meta-analysis. Thus, such words should not be part of the word count
matrix. This function allows the user to remove these columns of the word
count matrix by specifying a vector of words to delete.
}
\details{
The words in \code{delete_list} can be given like they appear in the
text. They are lemmatized and stemmed by \code{delete_words} to match the
columns of the word count matrix.
}
\examples{
path <- system.file("extdata", "test_data.csv", package = "MetaNLP", mustWork = TRUE)
obj <- MetaNLP(path)
del_words <- c("beautiful", "considering", "found")
obj <- delete_words(obj, del_words)


}
