% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeByPolygon.R
\name{summarizeByPolygon}
\alias{summarizeByPolygon}
\title{Summarize values by polygon}
\usage{
summarizeByPolygon(
  longitude,
  latitude,
  value,
  SFDF,
  useBuffering = FALSE,
  FUN,
  varName = "summaryValue"
)
}
\arguments{
\item{longitude}{vector of longitudes}

\item{latitude}{vector of latitudes}

\item{value}{vector of values at the locations of interest}

\item{SFDF}{simple features data frame with polygons used for aggregating}

\item{useBuffering}{passed to MazamaSpatialUtils::getSpatialData()}

\item{FUN}{function to be applied while summarizing (e.g. mean, max, etc.)}

\item{varName}{variable name assigned to the summary variable}
}
\value{
A dataframe with the same rows as `SFDF` but containing only two
columns: `polygonID` and the summary value.
}
\description{
Given vectors of longitudes, latitudes and values, this function
will summarize given values by spatial polygon using the \code{FUN} and return
a dataframe with polygon IDs and summary values.
}
\note{
This function has not been thoroughly tested and is included
in the package for experimental use only.
}
