% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertUSCensusCongress.R
\name{convertUSCensusCongress}
\alias{convertUSCensusCongress}
\title{Convert US congressional districts shapefile}
\usage{
convertUSCensusCongress()
}
\value{
Name of the datasetName being created.
}
\description{
Returns a simple features data frame for US Congressional Districts
for the 116th US House of Representatives.

The full resolution file will be named "USCensus116thCongress.rda". In addition,
"_05", _02" and "_01" versions of the file will be created that that are
simplified to 5\%, 2\% and 1\%. Simplified versions will greatly improve the
speed of both searching and plotting.
}
\details{
A US congressional district shapefile is downloaded and converted to
a simple features data frame with additional columns of data. The resulting
file will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.

#' The source data is from 2021.
}
\note{
From the source documentation:

Congressional Districts are the 435 areas from which people are elected to the
U.S. House of Representatives. After the apportionment of congressional seats
among the states based on census population counts, each state is responsible
for establishing congressional districts for the purpose of electing representatives.
Each congressional district is to be as equal in population to all other
congressional districts in a state as practicable. The 116th Congress is seated
from January 2019 to 2021. The cartographic boundary files for the District of
Columbia, Puerto Rico, and the Island Areas (American Samoa, Guam, the Commonwealth
of the Northern Mariana Islands, and the U.S. Virgin Islands) each contain a
single record for the non-voting delegate district in these areas. The boundaries
of all other congressional districts are provided to the Census Bureau by the
states by May 1, 2018.

You can join this file with table data downloaded from American FactFinder by
using the AFFGEOID field in the cartographic boundary file.
}
\references{
\url{https://www2.census.gov/geo/tiger/GENZ2021/}
}
\seealso{
setSpatialDataDir
}
\keyword{datagen}
