% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SimpleTimezones}
\alias{SimpleTimezones}
\title{Simplified spatial dataset of world timezones.}
\format{
A simple features data frame with 423 records and 9 columns of data.
}
\usage{
SimpleTimezones
}
\description{
This dataset is used by default in the \code{getTimezones()}
function and contains the following columns of data:
\itemize{
\item{\code{timezone} -- Olson timezone}
\item{\code{UTC_offset} -- offset from UTC (hours)}
\item{\code{UTC_DST_offset} -- offset from UTC during daylight savings (hours)}
\item{\code{countryCode} -- ISO 3166-1 alpha-2 country code}
\item{\code{longitude} -- longitude of the timezone polygon centroid}
\item{\code{latitude} -- longitude of the timezone polygon centroid}
\item{\code{status} -- one of 'Canonical', 'Alias' or 'Deprecated'}
\item{\code{notes} -- typically specifying the target of an 'Alias'}
\item{\code{polygonID} -- unique identifier (= \code{timezone})}
}

This dataset was generated on 2022-11-03 by running:

\preformatted{
library(MazamaSpatialUtils)
setSpatialDataDir("~/Data/Spatial_0.8")

convertOSMTimezones()

loadSpatialData("OSMTimezones_02")

SimpleTimezones <- OSMTimezones_02
save(SimpleTimezones, file = "data/SimpleTimezones.rda")
}
}
\keyword{datasets}
