% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RV.R
\name{RV}
\alias{RV}
\alias{RV2}
\alias{RVadj}
\alias{RVadjMaye}
\alias{RVadjGhaziri}
\title{RV coefficients}
\usage{
RV(X1, X2, center = TRUE, impute = FALSE)

RV2(X1, X2, center = TRUE, impute = FALSE)

RVadjMaye(X1, X2, center = TRUE)

RVadjGhaziri(X1, X2, center = TRUE)

RVadj(X1, X2, version = c("Maye", "Ghaziri"), center = TRUE)
}
\arguments{
\item{X1}{first \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{X2}{second \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{center}{\code{logical} indicating if input matrices should be centered (default = TRUE).}

\item{impute}{\code{logical} indicating if missing values are expected in \code{X1} or \code{X2} (only for RV and RV2).}

\item{version}{Which version of RV adjusted to apply: "Maye" (default) or "Ghaziri"
RV adjusted is run using the \code{RVadj} function.}
}
\value{
A single value measuring the similarity of two matrices.
}
\description{
Three different RV coefficients: RV, RV2 and adusted RV.
}
\details{
For each of the four coefficients a single scalar is computed to describe
the similarity between the two input matrices.
}
\examples{
X1  <- matrix(rnorm(100*300),100,300)
usv <- svd(X1)
X2  <- usv$u[,-3] \%*\% diag(usv$d[-3]) \%*\% t(usv$v[,-3])

RV(X1,X2)
RV2(X1,X2)
RVadj(X1,X2)

# Missing data
X1[c(1, 50, 400, 900)] <- NA
X2[c(10, 200, 450, 1200)] <- NA
RV(X1,X2, impute = TRUE)
RV2(X1,X2, impute = TRUE)

}
\references{
\itemize{
 \item{RV:}{ Robert, P.; Escoufier, Y. (1976). "A Unifying Tool for Linear Multivariate
  Statistical Methods: The RV-Coefficient". Applied Statistics 25 (3): 257-265.}
 \item{RV2:}{ Smilde, AK; Kiers, HA; Bijlsma, S; Rubingh, CM; van Erk, MJ (2009). "Matrix correlations
 for high-dimensional data: the modified RV-coefficient". Bioinformatics 25(3): 401-5.}
 \item{Adjusted RV:}{ Maye, CD; Lorent, J; Horgan, GW. (2011). "Exploratory analysis of multiple omics
 datasets using the adjusted RV coefficient". Stat Appl Genet Mol Biol. 10(14).}
 \item{Adjusted RV:}{ El Ghaziri, A; Qannari, E.M. (2015) "Measures of association between
 two datasets; Application to sensory data", Food Quality and Preference 40 (A): 116-124.}
}
}
\seealso{
\code{\link{SMI}}, \code{\link{r1}} (r2/r3/r4/GCD), \code{\link{Rozeboom}}, \code{\link{Coxhead}},
\code{\link{allCorrelations}} (matrix correlation comparison), \code{\link{PCAcv} (cross-validated PCA)}, \code{\link{PCAimpute} (PCA based imputation)}.
}
\author{
Kristian Hovde Liland, Benjamin Leutner (RV2)
}
