% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{setKey}
\alias{setKey}
\title{Step1: Set model's API key and url.}
\usage{
setKey(
  api_key,
  api_url = "https://api.openai.com/v1/chat/completions",
  model,
  ...
)
}
\arguments{
\item{api_key}{A character string: the user's OpenAI/huggingface/gemini/claude/baichuan/other API key.Please fill 'NA' for self-deployed models.}

\item{api_url}{A character string: the user's OpenAI/huggingface/gemini/claude/baichuan/other url .default is OpenAI. for gemini, you just input "https://generativelanguage.googleapis.com/"}

\item{model}{A character string: specify the model version.For gemini, you could input "gemini-pro"}

\item{...}{Variable parameter lists allow you to input additional parameters supported by the model you're using. Note: You must ensure the validity of the parameters you enter; otherwise, an error will occur.}
}
\value{
Prints a message to the console indicating whether the API key setup was successful.
If the setup fails, the function stops with an error message.
}
\description{
This function allows users to set and verify an API key for data collection. You can change the default api_url for others models' API.
}
\examples{
\dontrun{
set_key(api_key="YOUR_API_KEY", api_url="api.openai.com/v1/chat/completions",model="gpt-3.5-turbo")
}
}
