% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precheck.R
\name{preCheck}
\alias{preCheck}
\title{Step4: Pre-check for token usage in experiment design.}
\usage{
preCheck(
  data,
  checkToken = FALSE,
  systemPrompt = "",
  max_tokens = 500,
  temperature = 1,
  top_p = 1,
  n = 1,
  modality = "base",
  imgDetail = "auto"
)
}
\arguments{
\item{data}{A data.frame that has been structured by the 'experimentDesign' function, containing the experimental setup.}

\item{checkToken}{Whether to perform token count check, select TRUE to submit your experiment to our server's tokenizer for token count check, the default selection is FALSE (i.e., no token check will be performed, but you need to manually check if the number of tokens exceeds the model limit to avoid errors in the experiment).}

\item{systemPrompt}{The system prompt text used in the chatGPT model interaction. If left empty, a space character is assumed.}

\item{max_tokens}{The maximum number of tokens allowed for the model's response, default is 500.}

\item{temperature}{The temperature setting for the chatGPT model, controlling randomness. Default is 0.7.}

\item{top_p}{The top_p setting for the chatGPT model, controlling the diversity of responses. Default is 0.9.}

\item{n}{The number of model responses per prompt, default is 1. Relevant only if 'oneTrialMode' is TRUE.}

\item{modality}{The default mode of GPT is "base," with "img" as an optional choice.}

\item{imgDetail}{The image quality of the img modality is set to auto by default, with low/high as selectable options.}
}
\value{
A list containing the original data and the parameters for the chatGPT model interaction, confirming that the setup has passed the token checks or indicating issues if found.
}
\description{
Configures experimental parameters before execution.
}
\examples{

df <- data.frame(
Run = c(1,2),
Item = c(1,2),
Condition = c(1,2),
TargetPrompt = c("1","2")
)

ExperimentItem=loadData(df$Run,df$Item,df$Condition,promptList = df$TargetPrompt)

Design=experimentDesign(ExperimentItem,Step=1,random = TRUE)

gptConfig=preCheck(Design, systemPrompt="You are a participant in a psycholinguistic experiment",
                    max_tokens=10,temperature=0.7,top_p=1,n=1,modality='base',imgDetail="low")

}
