% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TR2.R
\name{TR2}
\alias{TR2}
\title{Robust Hotelling T^2 Test Statistic}
\usage{
TR2(x1, x2, alpha = 0.75)
}
\arguments{
\item{x1}{the data matrix for the first group. It must be matrix or data.frame.}

\item{x2}{the data matrix for the first group. It must be matrix or data.frame.}

\item{alpha}{numeric parameter controlling the size of the subsets over which the determinant is minimized. 
Allowed values are between 0.5 and 1 and the default is 0.75.}
}
\value{
a list with 2 elements:
\item{TR2}{The calculated value of Robust Hotelling T^2 statistic based on MRCD estimations}
}
\description{
Robust Hotelling T^2 Test Statistic for Two Independent Samples in high Dimensional Data
}
\details{
\code{TR2} function calculates the robust Hotelling T^2 test statistic for two independent samples in high dimensional data based on the minimum regularized covariance determinant estimators.
}
\examples{

library(rrcov)
x<-mvtnorm::rmvnorm(n=10,sigma=diag(20),mean=rep(0,20))
y<-mvtnorm::rmvnorm(n=10,sigma=diag(20),mean=rep(1,20))
TR2(x1=x,x2=y)
}
\references{
Bulut, H (2023). A robust Hotelling test statistic for two samples case in high dimensional data. (Unpublished)
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
