% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.CZIGP.R
\name{summary.CZIGP}
\alias{summary.CZIGP}
\title{Summary of parameter estimates of a multivariate compound ZIGP model}
\usage{
\method{summary}{CZIGP}(object, digits = 4, ...)
}
\arguments{
\item{object}{Output from a call to CZIGP.}

\item{digits}{The desired number of digits after the decimal point. Default of 4 digits is used.}

\item{...}{Additional arguments}
}
\value{
Summary for \code{CZIGPMM} objects.
}
\description{
This function returns the result of the \code{CZIGPMM} function
}
\examples{


x1 <- c(0,35,23,34,8,19,0,0,0,0)
x2 <- c(38,15,0,25,34,0,0,0,0,0)
y <- cbind(x1, x2)
phi0 = 0.5; phi = rep(0.5,2); la = rep(1,2); th = rep(0.1,2)
result <- CZIGPMM(y, phi0, phi, la, th)

summary(result,digits=4)

}
\seealso{
\code{\link{CZIGPMM}}
}
\keyword{methods}
