% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McCloskey_Perron.R
\name{McC.Perron}
\alias{McC.Perron}
\title{GPH estimation of long memory parameter robust to low frequency contaminations.}
\usage{
McC.Perron(X, m, epsilon = 0.05, method = c("adaptive", "trimmed"),
  Kl = 1)
}
\arguments{
\item{X}{vector of length T.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies.
used for the estimation usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{epsilon}{small constant that determines the choice of the trimming parameter l
used by the \code{gph} estimator. Default is \code{epsilon=0.05}.}

\item{method}{either "adaptive" or "trimmed" for the corresponding estimator.
Confer McCloskey and Perron (2013, ET) for details. Default is \code{method="adaptive"}.}

\item{Kl}{proportionality factor for bandwidth selection. Default is \code{Kl=1}.}
}
\description{
\code{McC.Perron} trimmed and adaptive log-periodogram estimators of 
             McCloskey and Perron (2013, ET) for robust estimation of the memory parameter d.
}
\details{
add details here. Recommendation of McCloskey, A. and Perron, P. (2013): Use trimmed 
version of estimator if there is reason to assume that shifts are present and use adaptive with 
\code{epsilon=0.05} and \code{m=T^0.8} if you are agnostic about the presence of shifts.
}
\examples{
library(fracdiff)
T<-1000
m<-floor(1+T^0.8)
d=0.4
series<-fracdiff.sim(n=T, d=d)$series
McC.Perron(series,m)
}
\references{
Robinson, P. M. (1995): Log-periodogram regression of time series with long range dependence. 
The Annals of Statistics, Vol. 23, No. 5, pp. 1048 - 1072.

McCloskey, A. and Perron, P. (2013): Memory parameter estimation in the presence of 
level shifts and deterministic trends. Econometric Theory, 29, pp. 1196-1237.
}
