% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hou_Perron.R
\name{Hou.Perron}
\alias{Hou.Perron}
\title{Modified local Whittle estimator of fractional difference parameter d.}
\usage{
Hou.Perron(data, m)
}
\arguments{
\item{data}{data vector of length T.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies
used for the estimation usually \code{floor(1+T^delta)}, where 0<delta<1.}
}
\description{
\code{Hou.Perron} Modified semiparametric local Whittle estimator of Hou and Perron (2014).
Estimates memory parameter robust to low frequency contaminations.
}
\details{
add details here
}
\examples{
library(fracdiff)
T<-1000
d<-0
mean<-c(rep(0,T/2),rep(2,T/2))
FI<-fracdiff.sim(n=T, d=d)$series
series<-mean+FI
ts.plot(series)
lines(mean, col=2)
local.W(series, m=floor(1+T^0.65))
Hou.Perron(series, m=floor(1+T^0.65))
}
\references{
Hou, J., Perron, P. (2014): Modified local Whittle estimator for long memory processes
in the presence of low frequency (and other) contaminations. Journal of Econometrics,  Vol. 182,
No. 2, pp. 309 - 328.
}
\author{
Christian Hendrik Leschinski
}
