% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_Datetime.R
\name{filter_Datetime_multiple}
\alias{filter_Datetime_multiple}
\title{Filter multiple times based on a list of arguments.}
\usage{
filter_Datetime_multiple(
  dataset,
  arguments,
  filter_function = filter_Datetime,
  ...
)
}
\arguments{
\item{dataset}{A light logger dataset}

\item{arguments}{A list of arguments to be passed to \code{\link[=filter_Datetime]{filter_Datetime()}} or
\code{\link[=filter_Date]{filter_Date()}}. each list entry must itself be a list of arguments, e.g,
\code{list(start = "2021-01-01", only_Id = quote(Id == 216))}. Expressions have
to be quoted with \code{\link[=quote]{quote()}} or \code{\link[rlang:expr]{rlang::expr()}}.}

\item{filter_function}{The function to be used for filtering, either
\code{filter_Datetime} (the default) or \code{filter_Date}}

\item{...}{Additional arguments passed to the filter function. If the
\code{length} argument is provided here instead of the \code{argument}, it has to be
written as a string, e.g., \code{length = "1 day"}, instead of \code{length = lubridate::days(1)}.}
}
\value{
A dataframe with the filtered data
}
\description{
\code{\link[=filter_Datetime_multiple]{filter_Datetime_multiple()}} is a wrapper around \code{\link[=filter_Datetime]{filter_Datetime()}} or
\code{\link[=filter_Date]{filter_Date()}} that allows the cumulative filtering of \code{Datetimes} based on
varying filter conditions. It is most useful in conjunction with the
\code{only_Id} argument, e.g., to selectively cut off dates depending on
participants (see examples)
}
\examples{
arguments <- list(
 list(start = "2023-08-31", only_Id = quote(Id == "Participant")),
 list(end = "2023-08-31", only_Id = quote(Id == "Environment")))
 #compare the unfiltered dataset
 sample.data.environment \%>\% gg_overview(Id.colname = Id)
 #compare the unfiltered dataset
 sample.data.environment \%>\%
 filter_Datetime_multiple(arguments = arguments, filter_Date) \%>\%
 gg_overview(Id.colname = Id)
}
