% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_EMA.R
\name{exponential_moving_average}
\alias{exponential_moving_average}
\title{Exponential moving average filter (EMA)}
\usage{
exponential_moving_average(
  Light.vector,
  Time.vector,
  decay = "90 min",
  epoch = "dominant.epoch"
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data. Missing values are
replaced by 0.}

\item{Time.vector}{Vector containing the time data. Can be \link[base]{POSIXct}, \link[hms]{hms},
\link[lubridate]{duration}, or \link[base]{difftime}.}

\item{decay}{The decay half-life controlling the exponential smoothing.
Can be either a \link[lubridate]{duration} or a string. If it is a string, it
needs to be a valid \link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.
The default is set to \code{"90 mins"} for a biologically relevant estimate (see
the reference paper).}

\item{epoch}{The epoch at which the data was sampled. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be
either \code{"dominant.epoch"} (the default) for a guess based on the data, or a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}
}
\value{
A numeric vector containing the smoothed light data. The output has the same
length as \code{Light.vector}.
}
\description{
This function smoothes the data using an exponential moving average filter
with a specified decay half-life.
}
\details{
The timeseries is assumed to be regular. Missing values in the
light data will be replaced by 0.
}
\examples{
sample.data.environment.EMA = sample.data.environment \%>\%
  dplyr::filter(Id == "Participant") \%>\%
  filter_Datetime(length = lubridate::days(2)) \%>\%
  dplyr::mutate(MEDI.EMA = exponential_moving_average(MEDI, Datetime))

# Plot to compare results
sample.data.environment.EMA \%>\%
  ggplot2::ggplot(ggplot2::aes(x = Datetime)) +
  ggplot2::geom_line(ggplot2::aes(y = MEDI), colour = "black") +
  ggplot2::geom_line(ggplot2::aes(y = MEDI.EMA), colour = "red")
  
}
\references{
Price, L. L. A. (2014). On the Role of Exponential Smoothing in Circadian
Dosimetry. \emph{Photochemistry and Photobiology}, 90(5), 1184-1192.
\doi{10.1111/php.12282}

Hartmeyer, S.L., Andersen, M. (2023). Towards a framework for light-dosimetry studies:
Quantification metrics. \emph{Lighting Research & Technology}.
\doi{10.1177/14771535231170500}
}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{duration_above_threshold}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{period_above_threshold}()},
\code{\link{pulses_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
