% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brown.R
\name{Brown_rec}
\alias{Brown_rec}
\title{Set the recommended illuminance/MEDI levels by Brown et al. (2022)}
\usage{
Brown_rec(
  state,
  Brown.day = "day",
  Brown.evening = "evening",
  Brown.night = "night",
  Brown.day.th = 250,
  Brown.evening.th = 10,
  Brown.night.th = 1
)
}
\arguments{
\item{state}{The state from Brown et al. (2022). Needs to be a character
vector.}

\item{Brown.day, Brown.evening, Brown.night}{The names of the states from Brown
et al. (2022). These are the default values (\code{"day"}, \code{"evening"},
\code{"night"}), but can be changed if the names in \code{state} are different. Needs
to be a character scalar.}

\item{Brown.day.th, Brown.evening.th, Brown.night.th}{The thresholds for the
states from Brown et al. (2022). These are the default values (\code{250}, \code{10},
\code{1}), but can be changed if the thresholds should be different. Needs to be
a numeric scalar.}
}
\value{
A dataframe with the same length as \code{state} that contains the
recommended illuminance/MEDI levels.
}
\description{
This is a lower level function. It sets the recommended
illuminance/MEDI levels by Brown et al. (2022) for a given state. The
function is vectorized.
}
\examples{
states <- c("day", "evening", "night")
Brown_rec(states)
Brown_rec(states, Brown.day.th = 100)

}
\references{
https://journals.plos.org/plosbiology/article?id=10.1371/journal.pbio.3001571
}
\seealso{
Other Brown: 
\code{\link{Brown2reference}()},
\code{\link{Brown_check}()},
\code{\link{sleep_int2Brown}()}
}
\concept{Brown}
