% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_semi}
\alias{opf_semi}
\title{Executes the semi supervised training phase}
\usage{
opf_semi(
  labeledTrainSubGraph,
  unLabeledTrainSubGraph,
  evaluatFile = NA,
  precomputedDistance = NA
)
}
\arguments{
\item{labeledTrainSubGraph}{The labeled training object (subGraph object)}

\item{unLabeledTrainSubGraph}{The unlabeled training object (subGraph object)}

\item{evaluatFile}{The evaluation object produced by the opf_split (subGraph object)}

\item{precomputedDistance}{The precomputed distance matrix produced by the opf_distance (leave it in blank if you are not using this resource)}
}
\value{
Returns a list which contains the classifier object and the classification list object
}
\description{
Executes the semi supervised training phase
}
\details{
Returns the learned model object
}
\examples{
Training <- opf_read_subGraph(system.file("extdata/Z1LINE.dat",package = "LibOPF"))
TUnlabeled <- opf_read_subGraph(system.file("extdata/Z1DOUBLELINE.dat",package = "LibOPF"))
Testing <- opf_read_subGraph(system.file("extdata/Z3.dat",package = "LibOPF"))
Y <- opf_semi(Training,TUnlabeled)
class <- opf_classify(Testing, Y$classifier)
acc <- opf_accuracy(Testing, class)

}
