% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_parallel_utils.R
\name{setup_llm_parallel}
\alias{setup_llm_parallel}
\title{Setup Parallel Environment for LLM Processing}
\usage{
setup_llm_parallel(strategy = NULL, workers = NULL, verbose = FALSE)
}
\arguments{
\item{strategy}{Character. The future strategy to use. Options: "multisession", "multicore", "sequential".
If NULL (default), automatically chooses "multisession".}

\item{workers}{Integer. Number of workers to use. If NULL, auto-detects optimal number (availableCores - 1, capped at 8).}

\item{verbose}{Logical. If TRUE, prints setup information.}
}
\value{
Invisibly returns the previous future plan.
}
\description{
Convenience function to set up the future plan for optimal LLM parallel processing.
Automatically detects system capabilities and sets appropriate defaults.
}
\examples{
\dontrun{
  # Automatic setup
  old_plan <- setup_llm_parallel()

  # Manual setup with specific workers
  setup_llm_parallel(workers = 4, verbose = TRUE)

  # Force sequential processing for debugging
  setup_llm_parallel(strategy = "sequential")

  # Restore old plan if needed
  future::plan(old_plan)
}
}
