% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Koboconnect.R
\name{kobo_media_downloader}
\alias{kobo_media_downloader}
\title{Downloads media data from Kobotoolbox}
\usage{
kobo_media_downloader(
  url = "eu.kobotoolbox.org",
  uname,
  pwd,
  assetid,
  fsep = ";",
  sleep = 2,
  identifier = "URL",
  timeoutval = 300,
  destfolder = "media"
)
}
\arguments{
\item{url}{The `[url]` of kobotoolbox Default is "eu.kobotoolbox.org".}

\item{uname}{is username of your kobotoolbox account}

\item{pwd}{is the password of the account}

\item{assetid}{is the id of the asset for which the export is to be created}

\item{fsep}{is the separator of the downloaded csv file. In most of the cases, it is ";", which is the default. However,}

\item{sleep}{is the sleep time between API actions. For example, it takes time to download an export. But R does not wait for the download to finish before going to next step. Hence the need to provide a break between consecutive API actions. Default value is 2 (seconds).}

\item{identifier}{is the key using with the columns with URL is identified. Default value is "URL" because in most of the cases, the columns
containing the URL values end with "URL". Please note that any other column name with similar value may cause error.}

\item{timeoutval}{is the timeout value in seconds to download the media files. Default is 300 seconds.}

\item{destfolder}{is the folder where the media is to be stored.}
}
\value{
The function returns a data frame of data downloaded from 'Kobotoolbox'.
}
\description{
`kobo_media_downloader` downloads media from data downloaded using `kobo_df_download`. Loops through media columns and downloads files individually.`
}
\details{
The function creates an export of survey data in 'csv'. If successful, it attempts to download the data and and return a data frame.
}
