% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftestevidence.R
\name{ftestEvidence}
\alias{ftestEvidence}
\title{Justify your alpha level by avoiding the Lindley paradox or aiming for moderate or strong evidence when using anova.}
\usage{
ftestEvidence(evidence, df1, df2, paired = FALSE, printplot = FALSE)
}
\arguments{
\item{evidence}{Desired level of evidence: "Lindley" to avoid the Lindley Paradox, "moderate" to achieve moderate evidence and "strong" to achieve strong evidence.
Users that are more familiar with Bayesian statistics can also directly enter their desired Bayes factor.}

\item{df1}{Numerator degrees of freedom.}

\item{df2}{Denominator degrees of freedom.}

\item{paired}{If true a within subjects design is assumed.}

\item{printplot}{If true prints a plot relating Bayes factors and p-values.}
}
\value{
numeric alpha level required to avoid Lindley's paradox.
}
\description{
Justify your alpha level by avoiding the Lindley paradox or aiming for moderate or strong evidence when using anova.
}
\section{References}{

Maier & Lakens (2021). Justify Your Alpha: A Primer on Two Practical Approaches
}

\examples{
## Avoid the Lindley paradox for an anova with 1 numerator and 248 denominator degrees of freedom.
ftestEvidence("lindley", 1, 248)
}
