% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotIncidencePopulation}
\alias{plotIncidencePopulation}
\title{Bar plot of denominator counts, outcome counts, and person-time from
incidence results}
\usage{
plotIncidencePopulation(
  result,
  x = "incidence_start_date",
  y = "denominator_count",
  facet = NULL,
  colour = NULL
)
}
\arguments{
\item{result}{Incidence results}

\item{x}{Variable to plot on x axis}

\item{y}{Variable to plot on y axis.}

\item{facet}{Variables to use for facets. To see available variables for
facetting use the functions \code{availableIncidenceGrouping()}.}

\item{colour}{Variables to use for colours. To see available variables for
colouring use the function \code{availableIncidenceGrouping()}.}
}
\value{
A ggplot object
}
\description{
Bar plot of denominator counts, outcome counts, and person-time from
incidence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalence(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2014-01-01"), as.Date("2018-01-01"))
)
inc <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
plotIncidencePopulation(inc)
}

}
