% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSchools.R
\name{addSchools}
\alias{addSchools}
\title{Add school data}
\usage{
addSchools(inputdir = getwd(), outputdir = getwd(), quiet = FALSE)
}
\arguments{
\item{inputdir}{a string indicating the path where \code{\link{ILSAmerge}} files are stored.}

\item{outputdir}{a string indicating where the combined data will be saved.}

\item{quiet}{a logical value indicating if progress status should be
shown. Default is \code{FALSE}.}
}
\value{
Saves combined student data and teacher data with added school data.
}
\description{
Add school data to student and teacher files merged by \code{\link{ILSAmerge}}.
It will run \code{\link{combineStudents}} internally.
To see which ILSA are available for adding school data use \code{\link{availableILSA}}.
}
\examples{
# Path where raw 'SPSS' files are
input <- system.file("extdata/timssadv", package = "ILSAmerge")

# Path where merged files will be saved
dir.create(file.path(tempdir(),"addSchools"))
output <- file.path(tempdir(),"addSchools")

# Merging 'TIMSS' Advanced 1995, as .rds file
ILSAmerge(inputdir = input, outputdir = output, filetype = "rds", quiet = FALSE)

# Check file names
list.files(output,pattern = ".rds")

# Add school data
addSchools(inputdir = output, outputdir = output)

# Check file names
list.files(output,pattern = ".rds")

}
