% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_smoothing.R
\name{cics_explicit_smooth}
\alias{cics_explicit_smooth}
\title{Smooth given data set by k-component non-uniform clamped interpolating spline (NcICS).}
\usage{
cics_explicit_smooth(
  xx,
  yy,
  uu,
  clrs = c("blue", "red"),
  d,
  xlab = NULL,
  ylab = NULL,
  title = NULL
)
}
\arguments{
\item{xx}{a vector of data set's \code{x}-coordinates (that are in increasing order).}

\item{yy}{a vector of data set's \code{y}-coordinates.}

\item{uu}{a vector of arbitrary nodes, based on which we construct the smoothing spline. uu[1] and uu[length(uu)] must be equal to xx[1] and xx[length(xx)], respectively.}

\item{clrs}{a vector of colours that are used alternately to plot the graph of spline's components.}

\item{d}{a vector (optional parameter) that contains two values of derivative, in the first and the last
node from \code{uu}. If missing, values of derivative are estimated by given linear regression model. If present, their
contribution is removed from linear model and only function values are estimated.}

\item{xlab}{a title (optional parameter) for the \code{x} axis.}

\item{ylab}{a title (optional parameter) for the \code{y} axis.}

\item{title}{a title (optional parameter) for the plot.}
}
\value{
a list with components
\item{est_spline_coeffs}{\code{4}-element array of \code{(k)x(k+3)} matrices, whereas element in \code{i}-th row and \code{j}-th
 of \code{l}-th matrix contains coefficient by \code{x^{l-1}} of cubic polynomial, which is in \code{i}-th row and \code{j}-th column  of matrix
\code{B} from smoothing spline's explicit form \deqn{S=B.\gamma.}}
\item{est_spline_polynomials}{list of string representations of smoothing NcICS.}
\item{est_gamma}{vector of estimated smoothing spline's coefficients (function values and exterior-node derivatives).}
\item{aux_BF}{A basis function of the spline}
\item{aux_tridiag_inverse}{An inverse of the tridiagonal matrix used for spline derivatives construction}
\item{aux_M}{An estimation matrix used to compute \code{est_gamma}}
}
\description{
\code{cics_explicit_smooth} constructs the non-uniform clamped interpolating spline with \code{k}
 components that smoothes
 given data set \code{{(xx[i],yy[i]), i=1..length(xx)}}.
}
\examples{

cics_explicit_smooth(
xx = CERN$x,
yy = CERN$y,
d = c(0, 1),
uu = c(1, sort(runif(20,1,277)), 277),
xlab = "X axis",
ylab = "Y axis"
)

yy <- c(1, 2, 3, 4, 3, 2, 2, 3, 5, 6, 7, 6, 5, 5, 4, 3, 2, 1, 0)
xx <- c(1:length(yy))
uu <- c(1,7,10,19)
sp <- cics_explicit_smooth(xx,yy,uu)
### We can change the derivatives at the end nodes:
sp <- cics_explicit_smooth(xx,yy, uu, d=c(3,-7/10))

### CERN:
uu <- c(1, 15, 26, 63, 73, 88, 103, 117, 132, 200, 203, 219, 258, 277)
sp <- cics_explicit_smooth(
  xx = CERN$x,
  yy = CERN$y,
  d = c(1, 0),
  uu
)
}
