% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESAC.R
\name{ESAC_test}
\alias{ESAC_test}
\title{ESAC single change-point test}
\usage{
ESAC_test(
  X,
  threshold_d = 1.5,
  threshold_s = 1,
  debug = FALSE,
  empirical = FALSE,
  thresholds = NULL,
  fast = FALSE,
  tol = 0.001,
  N = 1000,
  rescale_variance = TRUE
)
}
\arguments{
\item{X}{Matrix of observations, where each row contains a time series}

\item{threshold_d}{Leading constant for \eqn{\gamma(t) \propto r(t)} for \eqn{t=p}.  Only relevant when \code{empirical=FALSE} and \code{thresholds=NULL}}

\item{threshold_s}{Leading constant for \eqn{\gamma(t) \propto r(t)} for \eqn{t\leq \sqrt{p\log n}}. Only relevant when \code{empirical=FALSE} and \code{thresholds=NULL}}

\item{debug}{If \code{TRUE}, diagnostic prints are provided during execution}

\item{empirical}{If \code{TRUE}, detection thresholds are based on Monte Carlo simulation using \code{\link{ESAC_test_calibrate}}}

\item{thresholds}{Vector of manually chosen values of \eqn{\gamma(t)} for \eqn{t \in \mathcal{T}}, decreasing in \eqn{t}}

\item{fast}{If \code{TRUE}, ESAC only tests for a change-point at the midpoint of each seeded interval}

\item{tol}{If \code{empirical=TRUE}, \code{tol} is the false error probability tolerance}

\item{N}{If \code{empirical=TRUE}, \code{N} is the number of Monte Carlo samples used}

\item{rescale_variance}{If \code{TRUE}, each row of the data is re-scaled by a MAD estimate using \code{\link{rescale_variance}}}
}
\value{
1 if a change-point is detected, 0 otherwise
}
\description{
R wrapper for C function testing for a single change-point using ESAC \insertCite{@see @moen2023efficient}{HDCD}.
}
\examples{
library(HDCD)
n = 50
p = 50

# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
Y = matrix(rnorm(n*p), ncol = n, nrow=p)

# Adding a single sparse change-point to X (and not Y):
X[1:5, 26:n] = X[1:5, 26:n] +1

# Vanilla ESAC:
resX = ESAC_test(X)
resX
resY = ESAC_test(Y)
resY

# Manually setting leading constants for \lambda(t) and \gamma(t)
resX = ESAC_test(X, 
                 threshold_d = 2, threshold_s = 2, #leading constants for \gamma(t)
)
resX 
resY = ESAC_test(Y, 
                 threshold_d = 2, threshold_s = 2, #leading constants for \gamma(t)
)
resY

# Empirical choice of thresholds:
resX = ESAC_test(X, empirical = TRUE, N = 100, tol = 1/100)
resX
resY = ESAC_test(Y, empirical = TRUE, N = 100, tol = 1/100)
resY

# Manual empirical choice of thresholds (equivalent to the above)
thresholds_test_emp = ESAC_test_calibrate(n,p, N=100, tol=1/100,bonferroni=TRUE)
resX = ESAC_test(X, thresholds = thresholds_test_emp[[1]])
resX
resY = ESAC_test(Y, thresholds = thresholds_test_emp[[1]])
resY
}
\references{
\insertAllCited{}
}
