% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape_reviews.R
\name{scrape_reviews}
\alias{scrape_reviews}
\title{Scrape book reviews from Goodreads}
\usage{
scrape_reviews(
  book_ids_path,
  num_reviews = 30,
  use_parallel = FALSE,
  num_cores = 4
)
}
\arguments{
\item{book_ids_path}{A character string specifying the path to a file containing book IDs.}

\item{num_reviews}{An integer specifying the number of reviews to scrape per book. Default is 30.}

\item{use_parallel}{A logical value indicating whether to use parallel processing. Default is FALSE.}

\item{num_cores}{An integer specifying the number of cores to use for parallel processing. Default is 4.}
}
\value{
A data frame containing scraped review information.
}
\description{
This function scrapes book reviews from Goodreads based on provided book IDs.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)
# Run the function (with a small number of reviews to keep the example quick)
reviews <- scrape_reviews(temp_file, num_reviews = 5, use_parallel = FALSE)
print(head(reviews))
# Clean up: remove the temporary file
file.remove(temp_file)
}
}
