% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuppressKDisclosure.R
\name{KDisclosurePrimary}
\alias{KDisclosurePrimary}
\title{Construct primary suppressed difference matrix}
\usage{
KDisclosurePrimary(
  data,
  x,
  crossTable,
  mc_function,
  mc_hierarchies,
  freqVar,
  k = 1,
  upper_bound,
  ...
)
}
\arguments{
\item{data}{a data.frame representing the data set}

\item{x}{ModelMatrix generated by parent function}

\item{crossTable}{crossTable generated by parent function}

\item{mc_function}{a function for creating model matrix from mc_hierarchies}

\item{mc_hierarchies}{a hierarchy representing meaningful combinations to be
protected}

\item{freqVar}{name of the frequency variable in \code{data}}

\item{k}{numeric vector of length one, representing possible size of
attacking coalition}

\item{upper_bound}{numeric value representing minimum count considered safe.
Default set to \code{Inf}}

\item{...}{parameters passed to children functions}
}
\value{
dgCMatrix corresponding to primary suppressed cells
}
\description{
Function for constructing model matrix columns representing primary suppressed
difference cells
}
