% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.gene.lsn.data.R
\name{prep.gene.lsn.data}
\alias{prep.gene.lsn.data}
\title{Prepare Gene and Lesion Data}
\usage{
prep.gene.lsn.data(lsn.data, gene.data, mess.freq = 10)
}
\arguments{
\item{lsn.data}{data.frame with lesion data prepared by the user in a GRIN compatible format. The data.frame should has five columns that include "ID" which is the patient ID, "chrom" which is the chromosome on which the lesion is located, "loc.start" which is the lesion start position, "loc.end" the lesion end position and "lsn.type" which is the lesion type for example gain, loss, mutation, fusion, etc...}

\item{gene.data}{gene annotation data with four required columns: "gene" has ensembl ID, "chrom" which is chromosome on which the gene is located, "loc.start" gene start position, "loc.end" which is the gene end position}

\item{mess.freq}{message frequency: display message every mess.freq^th lesion block (default is 10).}
}
\value{
A list with the following components:
\item{lsn.data}{Input lesion data.}
\item{gene.data}{Input gene annotation data.}
\item{gene.lsn.data}{data.frame ordered by gene and lesions start positions. Gene start position is coded as 1 in the cty column and gene end position is coded as 4. Lesion start position is coded as 2 in the cty column and lesion end position is coded as 3.}
\item{gene.index}{data.frame that shows row start and row end for each chromosome in the gene.lsn.data table.}
\item{lsn.index}{data.frame that shows row start and row end for each lesion in the gene.lsn.data table.}
}
\description{
This function prepare gene and lesion data for later GRIN computations.
}
\details{
This function order and index gene and lesion data for later computations. Output of this function is used to ovelap gene and lesion data using find.gene.lsn.overlaps function.
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)

# prepare gene and lesion data for later computations:
prep.gene.lsn=prep.gene.lsn.data(lesion.data,
                                 hg19.gene.annotation)
}
\references{
Pounds, Stan, et al. (2013) A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=order.index.gene.data]{order.index.gene.data()}}, \code{\link[=order.index.lsn.data]{order.index.lsn.data()}}
}
\author{
{Stanley Pounds \email{stanley.pounds@stjude.org}}
}
