% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_singletons.R
\name{remove_singletons}
\alias{remove_singletons}
\title{Remove singletons}
\usage{
remove_singletons(data)
}
\arguments{
\item{data}{An object of class "GCalign". See \code{\link{align_chromatograms}} for details. Alternatively, a list of data frames. Whereby each data frame contains the peak list for an individual sample.}
}
\value{
a list of data frames for each individual.
}
\description{
Identifies and removes singletons (i.e. peaks that are unique for one sample) from the aligned dataset.
}
\examples{
data("peak_data")
## subset for faster processing
data <- lapply(peak_data[1:5], function(x) x[20:35,])
x <- align_chromatograms(data, rt_col_name = "time")
out <- remove_singletons(data = x)

}
\author{
Meinolf Ottensmann (meinolf.ottensmann@web.de) & Martin Stoffel (martin.adam.stoffel@gmail.com)
}
