% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2D_functions.R
\name{infocrit}
\alias{infocrit}
\title{Selection criteria for the approximate factor model}
\usage{
infocrit(Y, method, r_max = 10)
}
\arguments{
\item{Y}{A \eqn{T \times N} data matrix. T = number of time series observations,
N = cross-sectional dimension.}

\item{method}{A character string indicating which criteria to use.}

\item{r_max}{An integer indicating the maximum number of factors allowed. 10 by default.}
}
\value{
The estimated number of factors.
}
\description{
This function performs model selection for the (2D) approximate factor model
and returns the estimated number of factors.
}
\details{
"method" can be one of the following: "ICp2" and "BIC3" by Bai and Ng (2002),
"ER" by Ahn and Horenstein (2013), "ED" by Onatski (2010).
}
\examples{
# simulate data

T <- 100
N <- 50
r <- 2
F <- matrix(stats::rnorm(T * r, 0, 1), nrow = T)
Lambda <- matrix(stats::rnorm(N * r, 0, 1), nrow = N)
err <- matrix(stats::rnorm(T * N, 0, 1), nrow = T)
Y <- F \%*\% t(Lambda) + err

# estimation

r_hat <- infocrit(Y, "BIC3", r_max = 10)
}
\references{
Bai, J. and Ng, S., 2002. Determining the number of factors in approximate factor models.
Econometrica, 70(1), pp.191-221.

Ahn, S.C. and Horenstein, A.R., 2013. Eigenvalue ratio test for the number of factors.
Econometrica, 81(3), pp.1203-1227.

Onatski, A., 2010. Determining the number of factors from empirical distribution of eigenvalues.
The Review of Economics and Statistics, 92(4), pp.1004-1016.
}
