% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyNaiveBayes.R
\name{FuzzyNaiveBayes}
\alias{FuzzyNaiveBayes}
\title{Fuzzy Naive Bayes}
\usage{
FuzzyNaiveBayes(train, cl, fuzzy = TRUE, m = NULL, Pi = NULL)
}
\arguments{
\item{train}{matrix or data frame of training set cases}

\item{cl}{factor of true classifications of training set}

\item{fuzzy}{boolean variable to use the membership function}

\item{m}{is M/N, where M is the number of classes and N is the number of train lines}

\item{Pi}{is 1/M, where M is the number of classes}
}
\value{
A vector of classifications
}
\description{
\code{FuzzyNaiveBayes} Fuzzy Naive Bayes
}
\examples{

# Example Fuzzy with Discrete Features
set.seed(1) # determining a seed
data(HouseVotes84)

# Splitting into Training and Testing
split <- caTools::sample.split(t(HouseVotes84[, 1]), SplitRatio = 0.7)
Train <- subset(HouseVotes84, split == "TRUE")
Test <- subset(HouseVotes84, split == "FALSE")
# ----------------
# matrix or data frame of test set cases.
# A vector will be interpreted as a row vector for a single case.
test <- Test[, -1]
fit_FNB <- FuzzyNaiveBayes(
  train = Train[, -1],
  cl = Train[, 1]
)

pred_FNB <- predict(fit_FNB, test)

head(pred_FNB)
head(Test[, 1])


# Example Fuzzy with Continuous Features
set.seed(1) # determining a seed
data(iris)

# Splitting into Training and Testing
split <- caTools::sample.split(t(iris[, 1]), SplitRatio = 0.7)
Train <- subset(iris, split == "TRUE")
Test <- subset(iris, split == "FALSE")
# ----------------
# matrix or data frame of test set cases.
# A vector will be interpreted as a row vector for a single case.
test <- Test[, -5]
fit_FNB <- FuzzyNaiveBayes(
  train = Train[, -5],
  cl = Train[, 5]
)

pred_FNB <- predict(fit_FNB, test)

head(pred_FNB)
head(Test[, 5])


}
\references{
\insertRef{moraes2009another}{FuzzyClass}
}
