% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcc_show_results.R
\name{funcc_show_results}
\alias{funcc_show_results}
\title{Plotting co-clustering results of funCC}
\usage{
funcc_show_results(
  fun_mat,
  res_input,
  only.mean = FALSE,
  aligned = FALSE,
  warping = FALSE
)
}
\arguments{
\item{fun_mat}{The data array (n x m x T) where each entry corresponds to the measure of one observation i, i=1,...,n, for a functional variable m, m=1,...,p, at point t, t=1,...,T}

\item{res_input}{An object produced by the funcc_biclust function}

\item{only.mean}{logicol: if True only the template functions for each bi-cluster is displayed}

\item{aligned}{logicol: if True the alignemd functions are displayed}

\item{warping}{logicol: if True also a figure representing the warping functions are displayed}
}
\value{
a figure representing each bi-cluster in terms of functions contained in it or templates
}
\description{
funcc_show_results graphically shows the results of the bi-clustering
}
\examples{
 
data("funCCdata")
res <- funcc_biclust(funCCdata,delta=10,theta=1,alpha=1,beta=0,const_alpha=TRUE)
funcc_show_results(funCCdata,res)
}
