% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EW_liftoneDoptimal_log_GLM_func.R
\name{EW_liftoneDoptimal_log_GLM_func}
\alias{EW_liftoneDoptimal_log_GLM_func}
\title{EW Lift-one algorithm for D-optimal approximate design in log scale}
\usage{
EW_liftoneDoptimal_log_GLM_func(
  X,
  E_w,
  reltol = 1e-05,
  maxit = 100,
  random = FALSE,
  nram = 3,
  p00 = NULL
)
}
\arguments{
\item{X}{Model matrix, with nrow = num of design points and ncol = num of parameters}

\item{E_w}{Diagonal of E_W matrix in Fisher information matrix, can be calculated EW_Xw_maineffects_self() function in the ForLion package}

\item{reltol}{reltol The relative convergence tolerance, default value 1e-5}

\item{maxit}{The maximum number of iterations, default value 100}

\item{random}{TRUE or FALSE, if TRUE then the function will run with additional "nram" number of initial allocation p00, default to be TRUE}

\item{nram}{When random == TRUE, the function will generate nram number of initial points, default is 3}

\item{p00}{Specified initial design approximate allocation; default to be NULL, this will generate a random initial design}
}
\value{
p  EW D-optimal approximate allocation

p0 Initial approximate allocation that derived the reported EW D-optimal approximate allocation

Maximum The maximum of the determinant of the Fisher information matrix of the reported EW D-optimal design

convergence Convergence TRUE or FALSE

itmax number of the iteration
}
\description{
EW Lift-one algorithm for D-optimal approximate design in log scale
}
\examples{
hfunc.temp = function(y) {c(y,1);};   # y -> h(y)=(y1,y2,y3,1)
link.temp="logit"
paras_lowerbound<-rep(-Inf, 4)
paras_upperbound<-rep(Inf, 4)
gjoint_b<- function(x) {
mu1 <- -0.5; sigma1 <- 1
mu2 <- 0.5; sigma2 <- 1
mu3 <- 1; sigma3 <- 1
mu0 <- 1; sigma0 <- 1
d1 <- stats::dnorm(x[1], mean = mu1, sd = sigma1)
d2 <- stats::dnorm(x[2], mean = mu2, sd = sigma2)
d3 <- stats::dnorm(x[3], mean = mu3, sd = sigma3)
d4 <- stats::dnorm(x[4], mean = mu0, sd = sigma0)
return(d1 * d2 * d3 * d4)
}
x.temp=matrix(data=c(-2,-1,-3,2,-1,-3,-2,1,-3,2,1,-3,-2,-1,3,2,-1,3,-2,1,3,2,1,3),
              ncol=3,byrow=TRUE)
m.temp=dim(x.temp)[1]     # number of design points
p.temp=length(paras_upperbound)    # number of predictors
Xmat.temp=matrix(0, m.temp, p.temp)
EW_wvec.temp=rep(0, m.temp)
for(i in 1:m.temp) {
htemp=EW_Xw_maineffects_self(x=x.temp[i,],joint_Func_b=gjoint_b, Lowerbounds=paras_lowerbound,
                             Upperbounds=paras_upperbound, link=link.temp, h.func=hfunc.temp);
Xmat.temp[i,]=htemp$X;
EW_wvec.temp[i]=htemp$E_w;
}
EW_liftoneDoptimal_GLM_func(X=Xmat.temp, E_w=EW_wvec.temp, reltol=1e-8, maxit=1000, random=TRUE,
                            nram=3, p00=NULL)
}
