% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{tetools}
\alias{tetools}
\title{Temporal reconciliation tools}
\usage{
tetools(agg_order, fh = 1, tew = "sum", sparse = TRUE)
}
\arguments{
\item{agg_order}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \eqn{m}), or a vector representing a subset of \eqn{p} factors
of \eqn{m}.}

\item{fh}{Forecast horizon for the lowest frequency (most temporally aggregated)
time series (\emph{default} is \code{1}).}

\item{tew}{A string specifying the type of temporal aggregation. Options include:
"\code{sum}" (simple summation, \emph{default}), "\code{avg}" (average),
"\code{first}" (first value of the period), and "\code{last}"
(last value of the period).}

\item{sparse}{Option to return sparse matrices (\emph{default} is \code{TRUE}).}
}
\value{
A list with five elements:
\item{dim}{A vector containing information about the maximum aggregation order
(\code{m}), the number of factor (\code{p}), the partial (\code{ks}) and total
sum (\code{kt}) of factors.}
\item{set}{The vector of the temporal aggregation orders (in decreasing order).}
\item{agg_mat}{The temporal linear combination or aggregation matrix.}
\item{strc_mat}{The temporal structural matrix.}
\item{cons_mat}{The temporal zero constraints matrix.}
}
\description{
Some useful tools for forecast reconciliation through temporal hierarchies.
}
\examples{
# Temporal framework (quarterly data)
obj <- tetools(agg_order = 4, sparse = FALSE)

}
\seealso{
Temporal framework: 
\code{\link{teboot}()},
\code{\link{tebu}()},
\code{\link{tecov}()},
\code{\link{telcc}()},
\code{\link{temo}()},
\code{\link{terec}()},
\code{\link{tetd}()}

Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{shrink_estim}()},
\code{\link{teprojmat}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Framework: temporal}
\concept{Utilities}
