% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynloglikMC.R
\name{dynloglikMC}
\alias{dynloglikMC}
\title{Log-likelihood of a Lognormal-GPD dynamic mixture}
\usage{
dynloglikMC(x, y, nreps, xiInst, betaInst, weight)
}
\arguments{
\item{x}{if weight is equal to 'cau', (6 by 1) numerical vector: values of \eqn{\mu_c}, \eqn{\tau}, \eqn{\mu}, \eqn{\sigma}, \eqn{\xi}, \eqn{\beta};
if weight is equal to 'exp', (5 by 1) numerical vector: values of \eqn{\lambda}, \eqn{\mu}, \eqn{\sigma}, \eqn{\xi}, \eqn{\beta}.}

\item{y}{vector: points where the function is evaluated.}

\item{nreps}{non-negative integer: number of replications to be used in the computation of the integral in the normalizing
constant.}

\item{xiInst}{non-negative real: shape parameter of the instrumental GPD.}

\item{betaInst}{non-negative real: scale parameter of the instrumental GPD.}

\item{weight}{'cau' or 'exp': name of weight distribution.}
}
\value{
Log-likelihood of the lognormal-GPD mixture evaluated at y.
}
\description{
This function evaluates the log-likelihood of a Lognormal-GPD dynamic mixture,
with Cauchy or exponential weight, approximating the normalizing constant via Monte Carlo simulation.
}
\examples{
llik <- dynloglikMC(c(1,2,0,1,.25,3.5),Metro2019,10000,3,3,'exp')
}
\keyword{dynamic}
\keyword{mixture.}
