% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NHD_FUNCTIONS.R
\name{get_nhd}
\alias{get_nhd}
\title{Download and crop the National Hydrography Dataset.}
\usage{
get_nhd(
  template,
  label,
  nhdplus = FALSE,
  extraction.dir = file.path(tempdir(), "FedData", "extractions", "nhd", label),
  force.redo = FALSE
)
}
\arguments{
\item{template}{An \code{\link[sf:sf]{Simple Feature}}
or \code{\link[terra:SpatRaster-class]{SpatRaster}} object to serve as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{nhdplus}{Extract data from the USGS NHDPlus High Resolution service (experimental)}

\item{extraction.dir}{A character string indicating where the extracted and cropped NHD data should be put.}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}
}
\value{
A list of \code{sf} collections extracted from the National Hydrography Dataset.
}
\description{
\code{get_nhd} returns a list of \code{\link[sf:sf]{Simple Feature}} objects extracted
from the National Hydrography Dataset.
}
\examples{
\dontrun{
# Get the NHD (USA ONLY)
NHD <- get_nhd(
  template = FedData::meve,
  label = "meve"
)
NHD
NHD \%>\%
  plot_nhd(template = FedData::meve)
}
}
