% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SigmaAR.R
\name{SigmaAR}
\alias{SigmaAR}
\title{Simulate Covariance Matrix with an Auto-regressive (AR) Model}
\usage{
SigmaAR(n_rows, p_columns, phi)
}
\arguments{
\item{n_rows}{Number of samples (rows of X).}

\item{p_columns}{Number of variables (columns of X).}

\item{phi}{Auto-regression coefficient.}
}
\value{
A list with the values:
\item{\code{Sigma}}{A covariance matrix.}
\item{\code{Omega}}{A precision matrix.}
\item{\code{X}}{A normalized data matrix with Gaussian distribution.}
}
\description{
Helper function to simulate Simulate Gaussian Data with an Autoregressive (AR) Model
}
\examples{
data <- FastStepGraph::SigmaAR(30, 50, 0.4) # Simulate Gaussian Data
}
\author{
Prof. Juan G. Colonna, PhD. \email{juancolonna@icomp.ufam.edu.br}

Prof. Marcelo Ruiz, PhD. \email{mruiz@exa.unrc.edu.ar}
}
