% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastStepGraph.R
\name{FastStepGraph}
\alias{FastStepGraph}
\title{Fast Stepwise Gaussian Graphical Model}
\usage{
FastStepGraph(
  x,
  alpha_f,
  alpha_b = 0,
  nei.max = 5,
  data_scale = FALSE,
  max.iterations = NULL
)
}
\arguments{
\item{x}{Data matrix (of size n_samples x p_variables).}

\item{alpha_f}{Forward threshold  (no default value).}

\item{alpha_b}{Backward threshold. If alpha_b=0, then the alpha_b=0.5*alpha_f rule is applied.}

\item{nei.max}{Maximum number of variables in every neighborhood (default value 5).}

\item{data_scale}{Boolean parameter (TRUE or FALSE), when to scale data to zero mean and unit variance (default FALSE).}

\item{max.iterations}{Maximum number of iterations (integer), defaults set to three times the combination C(p,2)= p!/(2! * (p-2)!)}
}
\value{
A list with the values:
\item{\code{vareps}}{Response variables.}
\item{\code{beta}}{Regression coefficients.}
\item{\code{Edges}}{Estimated set of edges.}
\item{\code{Omega}}{Estimated precision matrix.}
}
\description{
Improved and faster implementation of the Stepwise Gaussian Graphical Algorithm.
}
\examples{
data <- FastStepGraph::SigmaAR(30, 50, 0.4) # Simulate Gaussian Data
G <- FastStepGraph::FastStepGraph(data$X, alpha_f = 0.22, alpha_b = 0.14)
}
\author{
Prof. Juan G. Colonna, PhD. \email{juancolonna@icomp.ufam.edu.br}

Prof. Marcelo Ruiz, PhD. \email{mruiz@exa.unrc.edu.ar}
}
