% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{start_gui}
\alias{start_gui}
\title{Start the FastRet GUI}
\usage{
start_gui(port = 8080, host = "0.0.0.0", reload = FALSE, nw = 2, nsw = 1)
}
\arguments{
\item{port}{The port the application should listen on}

\item{host}{The address the application should listen on}

\item{reload}{Whether to reload the application when the source code changes}

\item{nw}{The number of worker processes started. The first worker always listens for user input from the GUI. The other workers are used for handling long running tasks like model fitting or clustering. If \code{nw} is 1, the same process is used for both tasks, which means that the GUI will become unresponsive during long running tasks.}

\item{nsw}{The number of subworkers each worker is allowed to start. The higher this number, the faster individual tasks like model fitting can be processed. A value of 1 means that all subprocesses will run sequentially.}
}
\value{
A shiny app. This function returns a shiny app that can be run to interact with the model.
}
\description{
Starts the FastRet GUI
}
\details{
If you set \code{nw = 3} and \code{nsw = 4}, you should have at least 16 cores, one core for the shiny main process. Three cores for the three worker processes. And 12 cores (3 * 4) for the subworkers. For the default case, \code{nworkers = 1} and \code{nsw = 2}, you should have at least 4 cores.
}
\examples{
if (interactive()) start_gui()
}
\keyword{public}
