% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tictactoe.R
\name{tictactoe}
\alias{tictactoe}
\title{Construct a base tic-tac-toe plot for presenting predator-prey PSD values.}
\usage{
tictactoe(
  predobj = c(30, 70),
  preyobj = c(30, 70),
  predlab = "Predator PSD",
  preylab = "Prey PSD",
  obj.col = "black",
  obj.trans = 0.2,
  bnd.col = "black",
  bnd.lwd = 1,
  bnd.lty = 2
)
}
\arguments{
\item{predobj}{A vector of length 2 that contains the target objective range for the predator.}

\item{preyobj}{A vector of length 2 that contains the target objective range for the prey.}

\item{predlab}{A string representing a label for the x-axis.}

\item{preylab}{A string representing a label for the y-axis.}

\item{obj.col}{A string designating a color to which the target objective regions should be shaded.}

\item{obj.trans}{A numeric (decimal) that indicates the level of transparency for marking the target objective regions.}

\item{bnd.col}{A string that indicates a color for the boundaries of the target objective regions.}

\item{bnd.lwd}{A numeric that indicates the line width for the boundaries of the target objective regions.}

\item{bnd.lty}{A numeric that indicates the line type for the boundaries of the target objective regions.}
}
\value{
None. However, a graphic is produced.
}
\description{
Construct a base tic-tac-toe plot for presenting predator-prey PSD values. Predator-prey PSD values are added with \code{\link[plotrix]{plotCI}} from \pkg{plotrix}.
}
\details{
This function simply creates a base tic-tac-toe plot. Observed values, with confidence intervals, are added to this plot with \code{\link[plotrix]{plotCI}} from \pkg{plotrix}; see examples.
}
\section{IFAR Chapter}{
 6-Size Structure.
}

\examples{
## Create hypothetical data for plotting one point .. similar to what might come from psdCalc()
prey <- c(45.4,30.2,56.8)
pred <- c(24.5,10.2,36.7)
names(prey) <- names(pred) <- c("Estimate","95\% LCI","95\% UCI")
prey
pred

tictactoe()
if (require(plotrix)) {
  plotCI(prey[1],pred[1],li=prey[2],ui=prey[3],err="x",pch=16,add=TRUE)
  plotCI(prey[1],pred[1],li=pred[2],ui=pred[3],err="y",pch=16,add=TRUE) 
}

## Create hypothetical data for plotting three points ... similar to what might come from psdCalc()
prey <- rbind(c(45.4,30.2,56.8),
              c(68.2,56.7,79.4),
              c(17.1, 9.5,26.3))
pred <- rbind(c(24.5,10.2,36.7),
              c(14.2, 7.1,21.3),
              c(16.3, 8.2,24.4))
colnames(prey) <- colnames(pred) <- c("Estimate","95\% LCI","95\% UCI")
prey
pred

tictactoe()
if (require(plotrix)) {
  plotCI(prey[,1],pred[,1],li=prey[,2],ui=prey[,3],err="x",pch=16,add=TRUE)
  plotCI(prey[,1],pred[,1],li=pred[,2],ui=pred[,3],err="y",pch=16,add=TRUE)
}
lines(prey[,1],pred[,1])
text(prey[,1],pred[,1],labels=c(2010,2011,2012),adj=c(-0.5,-0.5))

}
\references{
Ogle, D.H. 2016. \href{https://fishr-core-team.github.io/fishR/pages/books.html#introductory-fisheries-analyses-with-r}{Introductory Fisheries Analyses with R}. Chapman & Hall/CRC, Boca Raton, FL.
}
\seealso{
See \code{\link{psdVal}} and \code{\link{psdCalc}} for related functionality.
}
\author{
Derek H. Ogle, \email{DerekOgle51@gmail.com}
}
\keyword{hplot}
