% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_RF.R
\name{predict_RF}
\alias{predict_RF}
\title{Pixel classification by Random Forest methodology (Classificacao de pixels pela metodologia Random Forest)}
\usage{
predict_RF(im,model,col="rand",plot=TRUE)
}
\arguments{
\item{im}{: Image that will be segmented (Imagem que sera segmentada).}

\item{model}{: Model adjusted by the "segmentation RF" function (Modelo ajustado pela funcao "segmentation_RF").}

\item{col}{: Vector with the desired colors in the segmentation. If it's "rand" it will be random colors
(Vetor com as cores desejadas na segmentacao. Se for "rand" serao cores aleatorias).}

\item{plot}{: Logical value, if TRUE, the image will be displayed
(Valor logico, se for TRUE a imagem sera apresentada).}
}
\value{
Returns the segmented image (Retorna a imagem segmentada).
}
\description{
This function classifies pixels in images from a random forest model
(Esta funcao classifica pixels em imagens a partir de um modelo de random forest).
}
\examples{

\donttest{
#Carregando imagens de exemplo
im=read_image(example_image(3))
Fundo=read_image(example_image(4))
Folha=read_image(example_image(5))
Ref=read_image(example_image(6))
paleta=list(Fundo=Fundo,Folha=Folha,Referencia=Ref)
col=c("black","green","red")

#### Criando imagem
Image=segmentation_RF(im=im,
                      palette=paleta,
                      return="image",
                      NumMax=1000,
                      col=col,
                      seed=NULL,
                      norma=1,
                      plot=TRUE)


#Criando um modelo
model=segmentation_RF(im=im,
palette=paleta,
return="model",
NumMax=1000,
col=col,
seed=NULL,
norma=1,
plot=FALSE)


image=predict_RF(im,model,col="rand",plot=TRUE)

}
}
\seealso{
\code{\link{segmentation_RF}} , \code{\link{segmentation_logit}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
