\name{epGraphs}
\alias{epGraphs}
\title{
epGraphs: ExPosition plotting function
}
\description{
	ExPosition plotting function which is an interface to \code{\link{prettyGraphs}}.
}

\usage{
epGraphs(res, x_axis = 1, y_axis = 2, epPlotInfo = NULL, DESIGN=NULL, 
	fi.col = NULL, fi.pch = NULL, fj.col = NULL, fj.pch = NULL, col.offset = NULL, 
	constraints = NULL, xlab = NULL, ylab = NULL, main = NULL, 
	contributionPlots = TRUE, correlationPlotter = TRUE,
	graphs = TRUE)
}

\arguments{
  \item{res}{results from ExPosition}
  \item{x_axis}{which component should be on the x axis?}
  \item{y_axis}{which component should be on the y axis?}
  \item{epPlotInfo}{A list (\code{$Plotting.Data}) from \code{epGraphs} or \code{ExPosition}.}    
  \item{DESIGN}{A design matrix to apply colors (by pallete selection) to row items}
  \item{fi.col}{A matrix of colors for the row items. If NULL, colors will be selected.}
  \item{fi.pch}{A matrix of pch values for the row items. If NULL, pch values are all 21.}  
  \item{fj.col}{A matrix of colors for the column items. If NULL, colors will be selected.}
  \item{fj.pch}{A matrix of pch values for the column items. If NULL, pch values are all 21.}    
  \item{col.offset}{A numeric offset value. Is passed to \code{\link{createColorVectorsByDesign}}.}
  \item{constraints}{Plot constraints as returned from \code{\link{prettyPlot}}. If NULL, constraints are selected.}      
  \item{xlab}{x axis label}
  \item{ylab}{y axis label}
  \item{main}{main label for the graph window}
  \item{contributionPlots}{a boolean. If TRUE (default), contribution bar plots will be created.}
  \item{correlationPlotter}{a boolean. If TRUE (default), a correlation circle plot will be created. Applies to PCA family of methods (CA is excluded for now).}
 \item{graphs}{a boolean. If TRUE, graphs are created. If FALSE, only data associated to plotting (e.g., constraints, colors) are returned.}  
}
\details{
epGraphs is an interface between \code{\link{ExPosition}} and \code{\link{prettyGraphs}}. 
}
\value{
	The following items are bundled inside of $Plotting.Data:\cr
\item{$fi.col}{the colors that are associated to the row items ($fi).}
\item{$fi.pch}{the pch values associated to the row items ($fi).}
\item{$fj.col}{the colors that are associated to the column items ($fj).}
\item{$fj.pch}{the pch values associated to the column items ($fj).}
\item{$constraints}{axis constraints for the plots (determines end points of the plots).}
}
\author{
Derek Beaton
}

\seealso{
 \code{\link{prettyGraphs}}
}
\examples{
	#this is for ExPosition's iris data
	data(ep.iris)
	pca.iris.res <- epPCA(ep.iris$data)
	#this will put plotting data into a new variable.
	epGraphs.2.and.3 <- epGraphs(pca.iris.res,x_axis=2,y_axis=3)
}
\keyword{ multivariate }
\keyword{ graphs }
\keyword{ misc }
