% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readICCS.R
\name{readCivEDICCS}
\alias{readCivEDICCS}
\title{Connect to ICCS and CivED Data}
\usage{
readCivEDICCS(
  path,
  countries,
  dataSet = c("student", "teacher"),
  gradeLvl = c("8", "9", "12"),
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{a character value of the full directory to the ICCS/CivED extracted SPSS (.sav) set of data}

\item{countries}{a character vector of the country/countries to include using
the three-digit International Organization for Standardization (ISO) country code.
A list of country codes can be found on Wikipedia at
\url{https://en.wikipedia.org/wiki/ISO_3166-1#Current_codes}
or other online sources. Consult the \emph{ICCS/CivED User Guide} to help determine what countries
are included within a specific testing year of ICCS/CivED.
To select all countries, use a wildcard value of \strong{\code{*}}.}

\item{dataSet}{a character value of either \code{student} or \code{teacher} to indicate which set of data is returned.
The student-level and teacher-level datasets cannot both be returned at the same time, unlike other IEA datasets.
Note: The CivED 1999 study also included student-to-teacher data for Grade 8.  Specifying \code{dataSet="student"} and \code{gradeLvl=8}
will include both the \code{student} and \code{teacher} data in the resulting \code{edsurvey.data.frame}.}

\item{gradeLvl}{a character value of the grade level to return
\itemize{
     \item{\strong{8} = eighth grade (the default if not specified)}
     \item{\strong{9} = ninth grade}
     \item{\strong{12} = 12th grade (for CivED 1999 only)}
}}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the \code{readCivEDICCS} function by using existing read-in data already processed.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for a single specified country or an \code{edsurvey.data.frame.list} if multiple countries specified
}
\description{
Opens a connection to an ICCS (2009, 2016) or CivEd (1999) data file and
             returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
Reads in the unzipped files downloaded from the international database(s) using the \href{https://www.iea.nl/data-tools/repository}{IEA Study Data Repository}.
         Data files require the SPSS data file (.sav) format using the default filenames.

When using the \code{getData} function with a CivED or ICCS study \code{edsurvey.data.frame},
         the requested data variables are inspected, and it handles any necessary data merges automatically.
         The \code{school} data always will be returned merged to the \code{student}
         data, even if only \code{school} variables are requested.
         If a 1999 CivED Grade 8 \code{edsurvey.data.frame} with \code{teacher} data variables is requested by the \code{getData} call,
         it will cause \code{teacher} data to be merged.
         Many \code{students} can be linked to many \code{teachers}, which varies widely between countries,
         and not all countries contain \code{teacher} data.

Calling the \code{dim} function for a CivED 1999 Grade 8 \code{edsurvey.data.frame} will result in the row count as if the \code{teacher} dataset was merged.
         This row count will be considered the \code{full data N} of the \code{edsurvey.data.frame}, even if no \code{teacher} data were included in an analysis.
         The column count returned by \code{dim} will be the count of unique column variables across all data levels.
}
\examples{
\dontrun{
eng <- readCivEDICCS("~/ICCS/2009/", countries = c("eng"),
                     gradeLvl = 8, dataSet = "student")
gg <- getData(getData=eng, varnames=c("famstruc", "totwgts", "civ"))
head(gg)
edsurveyTable(formula=civ ~ famstruc, data=eng)
}
}
\seealso{
\code{\link{readNAEP}}, \code{\link{readTIMSS}}, \code{\link{getData}}, and \code{\link{downloadCivEDICCS}}
}
\author{
Tom Fink
}
