% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Watson.pvalue.R
\name{Watson.pvalue}
\alias{Watson.pvalue}
\alias{Watson.uniform.pvalue}
\alias{Watson.normal.pvalue}
\alias{Watson.gamma.pvalue}
\alias{Watson.logistic.pvalue}
\alias{Watson.laplace.pvalue}
\alias{Watson.weibull.pvalue}
\alias{Watson.extremevalue.pvalue}
\alias{Watson.exp.pvalue}
\title{P-value of Watson statistic}
\usage{
Watson.uniform.pvalue(u, neig = 100, verbose = FALSE)

Watson.normal.pvalue(u, neig = 100, verbose = FALSE)

Watson.gamma.pvalue(u, shape, neig = 100, verbose = FALSE)

Watson.logistic.pvalue(u, neig = 100, verbose = FALSE)

Watson.laplace.pvalue(u, neig = 100, verbose = FALSE)

Watson.weibull.pvalue(u, neig = 100, verbose = FALSE)

Watson.extremevalue.pvalue(u, neig = 100, verbose = FALSE)

Watson.exp.pvalue(u, neig = 100, verbose = FALSE)
}
\arguments{
\item{u}{Watson statistic \eqn{U^2} with a given distribution.}

\item{neig}{Number of eigenvalues used for \code{imhof()}.}

\item{verbose}{Logical; if TRUE, print warning messages.}

\item{shape}{The shape parameter of Gamma distribution.}
}
\value{
P-value of the given Watson statistic.
}
\description{
Compute the P-value of the given Watson statistic \eqn{U^2}
using \code{\link[CompQuadForm]{imhof}} function in \code{CompQuadForm}.
}
\details{
Parameters must be estimated by maximum likelihood (ML) in order
for the P-values computed here to be asymptotically valid.
They are computed using the fact that when parameters are
estimated by maximum likelihood and the null hypothesis
is true, the asymptotic distribution of the GOF statistic
is the distribution of an infinite weighted sum
of weighted chi-square random variables on 1 degree of freedom.
The weights are eigenvalues of an integral equation. They
depend on the distribution being tested, the statistic being used,
and in some cases on the actual parameter values. These weights
are then computed approximately by discretization of the integral
equation; when that equation depends on one or more parameter
values we use the MLE in the equation.

Some notes on the specific distributions: For the Normal, Logistic,
Laplace, Extreme Value, Weibull and Exponential distributions, the
limiting distributions do not depend on the parameters. For the
Gamma distribution, the shape parameter affects the limiting
distribution. The tests remain asymptotically valid when the MLE
is used to approximate the limit distribution.

The Exponential distribution is a special case of the Weibull and
Gamma families arising when the shape is known to be 1. Knowing a
parameter and therefore not estimating it affects the distribution
of the test statistic and the functions provided for the Exponential
distribution allow for this.

If a data set X_1,...,X_n follows the Weibull distribution then
Y_1 = log(X_1), ... ,Y_n = log(X_n) follows the Extreme Value
distribution and vice versa. The two procedures give identical
test statistics and P-values, in principal.

Some of the models have more than one common parametrization. For
the Exponential, Gamma, and Weibull distributions, some writers
use a rate parameter and some use the scale parameter which is
the inverse of the rate. Our code uses the scale parameter.

For the Laplace distribution, some writers use the density
\eqn{f(x)= exp(-|x-\mu|/\beta)/(2\beta)} in which \eqn{\beta}
is a scale parameter. Others use the
standard deviation \eqn{\sigma = \beta/\sqrt{2}}. Our code
uses the scale parameter.

For the Uniform distribution, we offer code for the two parameter
Uniform distribution on the range \eqn{\theta_1} to \eqn{\theta_2}.
These are estimated by the sample minimum and sample maximum.
The probability integral transforms of the remaining n-2 points
are then tested for uniformity on the range 0 to 1. This procedure
is justified because the these probability integral transforms
have exactly this distribution if the original data had a uniform
distribution over any interval.

It is not unusual to test the hypothesis that a sample follows the
standard uniform distribution on [0,1]. In this case the parameters
\emph{should not} be estimated. Instead use \code{AD(z)} or \code{CvM(z)} or
\code{Watson(z)} to compute the statistic values and then get P-values from
\code{AD.uniform.pvalue(a)} or \code{CvM.uniform.pvalue(w)} or
\code{Watson.uniform.pvalue(u)} whichever is wanted.
}
\examples{
x0=runif(n=100,min=-1,max=1)
usq0 = Watson.uniform(x0)
Watson.uniform.pvalue(usq0)

x1=rnorm(n=100,mean=0,sd=1)
usq1 = Watson.normal(x1)
Watson.normal.pvalue(usq1)

x2=rgamma(n=100,shape=1,scale=1)
usq2 = Watson.gamma(x2)
Watson.gamma.pvalue(usq2,1)

x3=rlogis(n=100,location=0,scale=1)
usq3 = Watson.logistic(x3)
Watson.logistic.pvalue(usq3)

x4= rmutil::rlaplace(n=100,m=0,s=1)
usq4 = Watson.laplace(x4)
Watson.laplace.pvalue(usq4)

x5=rweibull(n=100,shape=1,scale=1)
usq5 = Watson.weibull(x5)
Watson.weibull.pvalue(usq5)
x5_log=log(x5)
Watson.extremevalue.pvalue(Watson.extremevalue(x5_log))

x6=rexp(n=100,rate=1/2)
usq6 = Watson.exp(x6)
Watson.exp.pvalue(usq6)
}
\seealso{
\code{\link{Watson}} for calculating Watson statistic;
\code{\link{CvM.pvalue}} for calculating P-value of Cramér-von Mises statistic;
\code{\link{AD.pvalue}} for calculating P-value of Anderson-Darling statistic.
}
