% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_mixed.R
\name{split_mixed_datasets}
\alias{split_mixed_datasets}
\title{Split mixed datasets}
\usage{
split_mixed_datasets(
  datasets = get_datasets(),
  id = get_subjid_cols(),
  ...,
  ignore_cols = get_meta_cols(0.95),
  output_code = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{datasets}{a dataframe or a list of dataframes to split. Default to all the datasets from \code{.lookup}.}

\item{id}{the patient identifier, probably "SUBJID". Should be shared by all datasets. Case-insensitive.}

\item{...}{not used}

\item{ignore_cols}{columns to ignore when considering a table as long. Default to \code{getOption("edc_cols_crfname", "CRFNAME")}. Case-insensitive.}

\item{output_code}{whether to print the code to explicitly write. Can also be a file path.}

\item{verbose}{whether to print informations about the process.}
}
\value{
a list of the new long and short tables. Use \code{\link[=load_list]{load_list()}} to load them into the global environment.
}
\description{
Split mixed tables, i.e. tables that hold both long data (N values per patient) and short data (one value per patient, duplicated on N lines), into one long table and one short table.
}
\examples{
#tm = read_trialmaster("filename.zip", pw="xx")
tm = edc_example_mixed()
names(tm)
#load_list(tm)
print(tm$long_mixed) #`val1` and `val2` are long but `val3` is short

mixed_data = split_mixed_datasets(tm, id="subjid", verbose=TRUE)
load_list(mixed_data)
print(long_mixed_short) 
print(long_mixed_long) 

#alternatively, get the code and only use the datasets you need
split_mixed_datasets(tm, id="SUBJID", output_code=TRUE)
filename = tempfile("mixed_code", fileext=".R")
split_mixed_datasets(tm, id="SUBJID", output_code=filename)
readLines(filename)
}
