% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{insulin.wide}
\alias{insulin.wide}
\title{"Wide format" Insulin data}
\format{
A data frame with 52 observations and 5 variables.

\describe{
\item{\code{sugar.before}}{Blood sugar measurement before administering insulin}
\item{\code{sugar.after}}{Blood sugar measurement after administering insulin}
\item{\code{time}}{Time of blood sugar measurement; minutes after administration of insulin}
\item{\code{experimenter}}{Initials of researcher who performed the experiment}
\item{\code{date}}{Date of experiment (month day)}
}
}
\source{
Banting, F. G., Best, C. H., Collip, J. B., Macleod, J. J., & Noble,
E. C. (1922). The effect of pancreatic extract (insulin) on normal rabbits.
American Journal of Physiology-Legacy Content, 62(1), 162-176.
}
\usage{
insulin.wide
}
\description{
This data set contains the same information as \link{insulin}, however it is
in \emph{wide format} rather than \emph{long format}. Refer to \link{insulin} for further details.
}
\seealso{
\link{insulin}, \link{petunia}, \link{damselfly}
}
\keyword{datasets}
