% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDrugUtilisation.R
\name{addDaysPrescribed}
\alias{addDaysPrescribed}
\title{To add a new column with the days prescribed. To add multiple columns use
\code{addDrugUtilisation()} for efficiency.}
\usage{
addDaysPrescribed(
  cohort,
  conceptSet,
  indexDate = "cohort_start_date",
  censorDate = "cohort_end_date",
  restrictIncident = TRUE,
  nameStyle = "days_prescribed_{concept_name}",
  name = NULL
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{conceptSet}{List of concepts to be included.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{restrictIncident}{Whether to include only incident prescriptions in the
analysis. If FALSE all prescriptions that overlap with the study period will
be included.}

\item{nameStyle}{Character string to specify the nameStyle of the new columns.}

\item{name}{Name of the new computed cohort table, if NULL a temporary table
will be created.}
}
\value{
The same cohort with the added columns.
}
\description{
To add a new column with the days prescribed. To add multiple columns use
\code{addDrugUtilisation()} for efficiency.
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockDrugUtilisation()
codelist <- getDrugIngredientCodes(cdm = cdm, name = "acetaminophen")
cdm <- generateDrugUtilisationCohortSet(cdm = cdm,
                                        name = "dus_cohort",
                                        conceptSet = codelist)

cdm$dus_cohort |>
  addDaysPrescribed(conceptSet = codelist) |>
  glimpse()
}

}
