% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateIngredientCohortSet.R
\name{generateIngredientCohortSet}
\alias{generateIngredientCohortSet}
\title{Generate a set of drug cohorts based on drug ingredients}
\usage{
generateIngredientCohortSet(
  cdm,
  name,
  ingredient = NULL,
  gapEra = 1,
  subsetCohort = NULL,
  subsetCohortId = NULL,
  numberExposures = FALSE,
  daysPrescribed = FALSE,
  ...,
  durationRange = lifecycle::deprecated(),
  imputeDuration = lifecycle::deprecated(),
  priorUseWashout = lifecycle::deprecated(),
  priorObservation = lifecycle::deprecated(),
  cohortDateRange = lifecycle::deprecated(),
  limit = lifecycle::deprecated()
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object.}

\item{name}{Name of the new cohort table, it must be a length 1 character
vector.}

\item{ingredient}{Accepts both vectors and named lists of ingredient names.
For a vector input, e.g., c("acetaminophen", "codeine"), it generates a
cohort table with descendant concept codes for each ingredient, assigning
unique cohort_definition_id. For a named list input, e.g., list(
"test_1" = c("simvastatin", "acetaminophen"), "test_2" = "metformin"),
it produces a cohort table based on the structure of the input, where
each name leads to a combined set of descendant concept codes for the
specified ingredients, creating distinct cohort_definition_id for each
named group.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era.}

\item{subsetCohort}{Cohort table to subset.}

\item{subsetCohortId}{Cohort id to subset.}

\item{numberExposures}{Whether to include 'number_exposures' (number of drug
exposure records between indexDate and censorDate).}

\item{daysPrescribed}{Whether to include 'days_prescribed' (number of days
prescribed used to create each era).}

\item{...}{Arguments to be passed to
\code{CodelistGenerator::getDrugIngredientCodes()}.}

\item{durationRange}{Deprecated.}

\item{imputeDuration}{Deprecated.}

\item{priorUseWashout}{Deprecated}

\item{priorObservation}{Deprecated.}

\item{cohortDateRange}{Deprecated.}

\item{limit}{Deprecated.}
}
\value{
The function returns the cdm reference provided with the addition of
the new cohort table.
}
\description{
Adds a new cohort table to the cdm reference with individuals who have drug
exposure records with the specified drug ingredient. Cohort start and end
dates will be based on drug record start and end dates, respectively. Records
that overlap or have fewer days between them than the specified gap era will
be concatenated into a single cohort entry.
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

cdm <- generateIngredientCohortSet(
  cdm = cdm,
  ingredient = "acetaminophen",
  name = "acetaminophen"
)

cdm$acetaminophen |>
  glimpse()
}

}
